/*
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="http://mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a><br>
 * @version 1.0<br>
 */ 
package org.esupportail.portal.utils.channels;

import java.util.HashMap;

import org.apache.log4j.Priority;

/**
 * IConfigActions<br>
 * <br>
 * Interface dcrivant les mthodes que doit implmenter une classe de configuration pour une channel
 * utilisant le principe des actions<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="http://mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 * 
 */
public interface IConfigActions extends Cloneable {
	
	/**
	 * La liste des actions lie  la configuration
	 * @return
	 */
	public HashMap getActions();
	
	/**
	 * Positionne la liste des actions lie  la configuration
	 * @param actions
	 */
	public void setActions(HashMap map);
	
	/**
	 * Encoding XML
	 * @return
	 */
	public String getXmlEncoding();
	
	/**
	 * Retourne le niveau de log
	 * @return
	 */
	public Priority getLogLevel();
	
	/**
	 * Retourne le niveau de log sous forme de string 
	 * @return
	 */
	public String getLog();
	
	/**
	 * Pour support du clonage
	 * @return
	 * @throws CloneNotSupportedException
	 */
	public Object clone() throws CloneNotSupportedException;
}
