/*
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a><br>
 * @version 1.0
 */ 
package org.esupportail.portal.utils.channels;


import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

import org.apache.log4j.Priority;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * SubChannelFactory<br>
 * <br>
 * "Usine" qui fabrique des SubChannel  la demande d'une MainChannel<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 * 
 */
public class SubChannelFactory {

	/**
	 * Mthode statique qui permet d'instancier une SubChannel correspondant  une action
	 * 
	 * @param mainChannel channel principale qui cherche  instancier une SubChannel
	 * @param action action pour laquelle on veut instancier la SubChannel
	 * @return la SubChannel correspondant  l'action
	 * @throws PortalException
	 */
	public static ISubChannel instantiateAction(MainChannel mainChannel, Action action) throws PortalException {
		Class subChannelClass = null;
		Object subChannelObj = null;
		ISubChannel res = null;
		
		if (action.getClassname() != null)
			// Instanciation de la sous-channel correspondant  l'action
			try {
				mainChannel.log("SubChannelFactory::instantiateAction() : Tentative d'instanciation de la sub-channel " + action.getClassname());
				mainChannel.log("SubChannelFactory::instantiateAction() : Recherche classe sub-channel");
				subChannelClass = Class.forName(action.getClassname());
				mainChannel.log("SubChannelFactory::instantiateAction() : Recherche types params constructeur sub-channel");
				Class[] types = {MainChannel.class};
				mainChannel.log("SubChannelFactory::instantiateAction() : Recherche constructeur");
				Constructor cons = subChannelClass.getConstructor(types);
				Object[] params = {mainChannel};
				mainChannel.log("SubChannelFactory::instantiateAction() : Utilisation constructeur");
				subChannelObj = cons.newInstance(params);
				res = (ISubChannel)subChannelObj;
				mainChannel.log("SubChannelFactory::instantiateAction() : Instanciation de la sub-channel " + 
					action.getClassname() + " russie !");
			}
			catch (Exception e) {
				res = null;
				mainChannel.log(Priority.ERROR, "SubChannelFactory::instantiateAction() : Echec de l'instanciation de la sub-channel :  " + action.getClassname() + 
						"\n" + MainChannel.stack2string(e));
				throw new PortalException("Echec de l'instanciation de la sub-channel :  " + action.getClassname() +  
						" voir le log uportal");
			}
		return res;
	}

	/**
	 * Appel de la mthode init d'une action (mthode 1/3 du cycle de vie)
	 * 
	 * @param subChannel SubChannel correspondant  l'action
	 * @param action Action en cours
	 * @param rd RuntimeData  utiliser
	 * @return Boolean.TRUE si le cycle de vie de la SubChannel peut se poursuivre
	 * @throws PortalException
	 * @throws Throwable
	 * @throws FrameWorkException
	 */
	public static Boolean callInit(ISubChannel subChannel, Action action, ChannelRuntimeData rd)  throws Throwable, PortalException, FrameWorkException {
		Boolean res = Boolean.FALSE;
		Object obj = null;

		try {
			subChannel.log("SubChannelFactory::callInit() : invocation de la mthode " + action.getClassname() + "." + 
				action.getInit());
			Class[] types = {rd.getClass()};
			subChannel.log("SubChannelFactory::callInit() : rd = " + rd.getClass());
			Class currentSubChannelClass = subChannel.getClass();
			subChannel.log("SubChannelFactory::callInit() : getmethod");
			Method method = currentSubChannelClass.getMethod(action.getInit(), types);
			Object[] args = {rd};
			subChannel.log("SubChannelFactory::callInit() : invoke");
			obj = method.invoke(subChannel, args);
			subChannel.log("SubChannelFactory::callInit() : aprs invoke");
			// A-t-on bien rcupr un Boolean?
			if (obj instanceof Boolean)
				res = (Boolean)obj;
			else
				throw new PortalException("La mthode " + action.getInit() +
				  "ne renvoie pas un boolen");
		}
		catch (Exception e) {
			subChannel.log(Priority.ERROR, "SubChannelFactory::callInit() : Impossible d'appeler la mthode " + action.getClassname() + "." + 
					action.getInit() + "\n" + MainChannel.stack2string(e));
					
			if (e.getCause() instanceof FrameWorkException) {
				subChannel.log("SubChannelFactory::callInit() : FrameWorkException levee");
				throw e.getCause();
			}
			else {
				subChannel.log("SubChannelFactory::callInit() : PortalException levee");
				throw new PortalException("Impossible d'appeler la mthode " + action.getClassname() + "." + 
					action.getInit() + " voir le log uportal");
			}		
		}
		return res;
	}

	/**
	 * Appel de la mthode setXML d'une action (mthode 2/3 du cycle de vie)
	 * 
	 * @param subChannel SubChannel correspondant  l'action
	 * @param action Action en cours
	 * @param rd RuntimeData  utiliser
	 * @return Boolean.TRUE si le cycle de vie de la SubChannel peut se poursuivre
	 * @throws PortalException
	 * @throws Throwable
	 * @throws FrameWorkException
	 */
	public static Boolean callSetXML(ISubChannel subChannel, Action action, ChannelRuntimeData rd)  throws Throwable, PortalException, FrameWorkException {
		Boolean res = Boolean.FALSE;
		Object obj = null;

		try {
			subChannel.log("SubChannelFactory::callSetXML() : invocation de la mthode " + action.getClassname() + "." + 
				action.getSetXML());
			Class[] types = {};
			Class currentSubChannelClass = subChannel.getClass();
			Method method = currentSubChannelClass.getMethod(action.getSetXML(), types);
			Object[] args = {};
			obj = method.invoke(subChannel, args);
			// A-t-on bien rcupr un Boolean?
			if (obj instanceof Boolean)
				res = (Boolean)obj;
			else
				throw new PortalException("La mthode " + action.getSetXML() +
				  "ne renvoie pas un boolen");
		}
		catch (Exception e) {
			subChannel.log(Priority.ERROR, "SubChannelFactory::callSetXML() : Impossible d'appeler la mthode " + action.getClassname() + "." + 
					action.getSetXML() + "\n" + MainChannel.stack2string(e));
			if (e.getCause() instanceof FrameWorkException) {
				subChannel.log("SubChannelFactory::callSetXML() : FrameWorkException levee");
				throw e.getCause();
			}
			else {
				subChannel.log("SubChannelFactory::callSetXML() : PortalException levee");
				throw new PortalException("Impossible d'appeler la mthode " + action.getClassname() + "." + 
							action.getSetXML() + " voir le log uportal");
			}
				
		}
		
		return res;
	}

	/**
	 * Appel de la mthode setOutput d'une action (mthode 3/3 du cycle de vie)
	 * 
	 * @param subChannel SubChannel correspondant  l'action
	 * @param action Action en cours
	 * @param rd RuntimeData  utiliser
	 * 
	 * @throws PortalException
	 */
	public static void callSetOutput(ISubChannel subChannel, Action action, ChannelRuntimeData rd)  throws PortalException {
		Object obj = null;

		try {
			subChannel.log("SubChannelFactory::callSetOutput() : invocation de la mthode " + action.getClassname() + "." + 
				action.getSetOutput());
			Class[] types = {};
			Class currentSubChannelClass = subChannel.getClass();
			Method method = currentSubChannelClass.getMethod(action.getSetOutput(), types);
			Object[] args = {};
			obj = method.invoke(subChannel, args);
		}
		catch (Exception e) {
			subChannel.log(Priority.ERROR, "SubChannelFactory::callSetOutput() : Impossible d'appeler la mthode " + action.getClassname() + "." + 
					action.getSetOutput() + "\n" + MainChannel.stack2string(e));
			throw new PortalException("SubChannelFactory::callSetOutput() : Impossible d'appeler la mthode " + action.getClassname() + "." + 
			action.getSetOutput() + " voir le log uportal");
		}
	}
	
}
