/*
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a><br>
 * @version 1.0<br>
 */ 
package org.esupportail.portal.utils.channels.plugins;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.esupportail.portal.utils.channels.ActionParam;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.jasig.portal.PortalException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;

/**
 * RestrictedAction<br>
 * <br>
 * Ce plug-in ajoute n'est pas un vritable plugin au sens MAG.
 * C'est  dire qu'il n'est pas ncessaire de faire un "register" 
 * et qu'il n'y a pas de prise en charge d'affichage.<br>
 * L'interet de cette clase est de fournir une mthode statique pour 
 * filtrer l'accs d'une personne  une action.<br>
 * De plus cette classe met dans les staticData le groupe reconnu.
 *  
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author Sbastien GAUDIN
 * @version 1.0
 * 
 */
public class RestrictedAction extends SubChannel {

	static private String plugName = "plug.esup.restrictedAction";
	
	
	
	/**
	 * Constructeur
	 * @param main
	 */
	public RestrictedAction(MainChannel main) {
		super(main);
	}
	
		 
	
	/**
	 * Mthode statique qui permet de filtrer l'accs sur l'action en cours
	 * par rapport aux groupes auquel appatient la personne connecte
	 * 
	 * @param la mainchannel
	 * @param le nom de l'action en cours
	 * @param le mapping des groupes
	 * @param l'autorisation d'accs en cas de non dclaration de groupe
	 */
	public static boolean filterAccess(MainChannel main,String currentAction,HashMap mapping,boolean allowWithoutGroupSpecification) throws PortalException,FrameWorkException {
		
		LogService.log(LogService.INFO,plugName+" : Access reserve");
		ActionParam paramGroup = main.getActionParam(currentAction,plugName);
		
		/*Si aucun groupe n'est prcis dans la configuration et que l'on autorise tout le monde*/
		if ( (paramGroup==null) && (allowWithoutGroupSpecification) ){
		    main.getStaticData().put(plugName,"");
			return true;
		}
	
		
		LinkedList  listGroup = new LinkedList ();
		/*Si aucun groupe n'est prcis dans la configuration et que l'on autorise uniquement les groupes dclars*/
		if ( paramGroup!=null ){
		    listGroup = (LinkedList)paramGroup.getValues();
		}
		else{
		    listGroup.addAll((Collection)mapping.keySet());
		}
		
		
		
		if (main.getStaticData().get(plugName)!=null){
			/*On connais le groupe d'apartenance de la personne connecte
			 *On cherche si ce groupe est autoris  acceder  l'action en cours
			 */
			Iterator j = listGroup.iterator();
			/*... on recherche la cl*/
			while(j.hasNext()) {  
				String localNameGroup = (String)j.next();
				if (localNameGroup.equals(main.getStaticData().get(plugName))){
			    	LogService.log(LogService.INFO,plugName+" : groupe utilise : "+main.getStaticData().get(plugName));
			    	return true;
		        }
			}
			return false;
		}
		
		/*On ne connais pas le groupe d'apartenance de la personne connecte
		 */	
		
		IEntity user = null;
		String login = (String)main.getStaticData().getPerson().getAttribute(IPerson.USERNAME);
		user = GroupService.getEntity(login, org.jasig.portal.security.IPerson.class);  
	    
		
		
 	  	  if(user != null) {  
	           Iterator groupsTest;
	           
	            groupsTest = user.getAllContainingGroups();
	            
	            
				/*Parcours des groupes de la personne connecte*/
				while(groupsTest.hasNext()) {  
					IGroupMember groupTmp = (IGroupMember)groupsTest.next(); 
	              
					Iterator j = listGroup.iterator();
					/*parcours des groupes autoriss pour l'action en cours*/
					while(j.hasNext()) {  
						String localNameGroup = (String)j.next();
						if (mapping.get(localNameGroup).equals(groupTmp.getKey())){
					    	LogService.log(LogService.INFO,plugName+" : groupe trouve : "+groupTmp.getKey()+ " ("+localNameGroup+")");
					    	main.getStaticData().put(plugName,localNameGroup);
					    	return true;
				        }
					}
				}   
				
				LogService.log(LogService.INFO,plugName+" : aucun groupe trouve");
		   		
		   		return false;
	      }  
	      else {  
	           LogService.log(LogService.ERROR,plugName+" : Utilisateur " + login + " inexistant");  
	           throw new FrameWorkException("Utilisateur " + login + " inexistant");
	      }
 	  	
	}
	
	/*
	 * Appel de la mthode filterAccess en autorisant l'accs
	 * aux actions sans dclaration de groupe
	 * 
	 * @param la mainchannel
	 * @param le nom de l'action en cours
	 * @param le mapping des groupes
	 */
	public static boolean filterAccess(MainChannel main,String currentAction,HashMap mapping) throws PortalException,FrameWorkException {

		return filterAccess(main,currentAction,mapping, true);
	}
	



}