<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="no" />
  <xsl:param name="baseActionURL"></xsl:param>
  <xsl:param name="prefForm"></xsl:param>
  <xsl:param name="mediaPath"></xsl:param>
  
<xsl:template match="/xml">
     
	
	<!-- Affichage des messages -->	
	<table border="0" cellspacing="5">
    	<xsl:apply-templates select="message" />
    </table>
    	
    <!-- Si action alors cration du formulaire -->
    <xsl:if test="./action/@name != ''">
		<form name="{$prefForm}Message" action="{$baseActionURL}" method="post">
		<input type="hidden" name="action" value="{./action/@name}" />
		
		<xsl:apply-templates select="./parameters/parameter" />
		
		<input class="uportal-button" type="submit" value="OK" name="save"/>
		</form>
	</xsl:if>
</xsl:template>

<!-- Affichage d'un message -->
<xsl:template match="message">
	<tr>
		<xsl:choose>
			<xsl:when test="./@type='ERROR'">
				<td valign="absmiddle"><img src="{$mediaPath}errormessage.gif" border="0"/></td>
		    	<td class="uportal-channel-table-header">Erreur :</td>
			</xsl:when>
			<xsl:when test="./@type='WARNING'">
				<td valign="absmiddle"><img src="{$mediaPath}warningmessage.gif" border="0"/></td>
		    	<td class="uportal-channel-table-header">Attention :</td>
			</xsl:when>
			<xsl:when test="./@type='INFO'">
				<td valign="absmiddle"><img src="{$mediaPath}infomessage.gif" border="0"/></td>
		    	<td class="uportal-channel-table-header">Information :</td>
			</xsl:when>
		</xsl:choose>
    	
    	<td class="uportal-channel-strong"><xsl:value-of select="./@message"/></td>
    </tr>
</xsl:template>

<!-- Si paramtres  transmettre insertion en champs cachs -->	
<xsl:template match="parameter">
	<input type="hidden" name="{./@name}" value="{./@value}" />
</xsl:template>

</xsl:stylesheet>