/* 
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Sbastien GAUDIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/
package org.esupportail.portal.utils.LDAP;
    
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.Attributes; 
import javax.naming.directory.SearchControls;
import javax.naming.*;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.jasig.portal.services.LogService;

public class LDAPHandler {

	private String[] attributes = null;
	private String[] attributesValues = null;
	private int maxEntries = 0;
	private String base = null;
	private String filter = null;
	private int scope = 0;
	private String url = null;
	private String bindDn = null;
	private String bindPass = null;
	private InitialDirContext ctx = null;
	private Hashtable env = null;

	public LDAPHandler() {LogService.log(
			LogService.INFO,
			"LDAPHandler:LDAPHandler() : constructeur");
	}

	public void setAttributes(String[] listAttr) {
		attributes = listAttr;
	}
	
	public void setAttributesValues(String[] listValues) {
		attributesValues = listValues;
	}

	public void setMaxEntries(int max) {
		maxEntries = max;
	}
 
	public void setBase(String b) {
		base = b;
	}

	public void setFilter(String f) {
		filter = f;
	}

	public void setScope(int s) {
		scope = s;
	}

	public void setUrl(String u) {
		url = u;
	}
	
	public void setBindDn(String u) {
		bindDn = u;
	}
	
	public void setBindPass(String u) {
		bindPass = u;
	}

	public NamingEnumeration search() {
		NamingEnumeration answer = null;

		if (authenticate()){
		
			/*Criteres de recherche*/
			SearchControls sc = new SearchControls();
			sc.setReturningAttributes(attributes);
			sc.setCountLimit(maxEntries);
			sc.setSearchScope(scope);
			
			/*Lance la recherche*/	
			try {
				answer = ctx.search(base, filter, sc);
			} catch (NamingException e) {
				LogService.log(
					LogService.ERROR,
					"LDAPHandler:search() : " + e.toString());
				return null;
			}
		}
		
		return (answer);
	}

	public void close() {
		try {
			ctx.close();
		} catch (NamingException e) {
			LogService.log(
				LogService.ERROR,
				"LDAPHandler:search() : " + e.toString());
		}
	}
		
	public boolean authenticate(){
		
		String dnLog = "anonymous";
		
		env = new Hashtable();
		env.put(
			InitialDirContext.INITIAL_CONTEXT_FACTORY,
			"com.sun.jndi.ldap.LdapCtxFactory");
		env.put(Context.PROVIDER_URL, url);
		
		
		if(bindDn != null){
			env.put(InitialDirContext.SECURITY_AUTHENTICATION, "simple");
			env.put(InitialDirContext.SECURITY_PRINCIPAL,      bindDn);
			env.put(InitialDirContext.SECURITY_CREDENTIALS,    bindPass);
			dnLog = bindDn;
		}

		ctx = null;
		try {
			ctx = new InitialDirContext(env);
		}
		catch (Exception e){
			close();
			LogService.log(
					LogService.INFO,
					"LDAPHandler:authenticate() : " + dnLog +" authentification failed");
			return false;
		}
		
		LogService.log(
				LogService.INFO, 
				"LDAPHandler:authenticate() : " + dnLog +" authenticated");
		return true;			
	}

	public void write(String shortDn) throws FrameWorkException{
		if (authenticate()){
			
			Attributes a = null;
			try {
				a = ctx.getAttributes(shortDn,attributes);
			} catch (NamingException e1) {
				LogService.log(LogService.ERROR,"LDAPHandler:write() : NamingException : "+e1);
				throw new FrameWorkException("erreur dans l'acquisition d'un attribut.");
			}
			if (a!=null){
				for (int i=0;i<attributes.length;i++){
					if(!a.get(attributes[i]).contains(attributesValues[i])) {                   
						a.get(attributes[i]).remove(0);
						a.get(attributes[i]).add(attributesValues[i]);
						
						try {
		                    ctx.modifyAttributes(shortDn,InitialDirContext.REPLACE_ATTRIBUTE,a);
			            }
			            catch(NamingException e) {
			            	LogService.log(
			        				LogService.ERROR,
			        				"LDAPHandler:write() : modifyAttributes=>" + e.toString());
							throw new FrameWorkException("erreur dans l'acquisition d'un attribut.");
			            } 
					}
				}
			}	
			else{
            	LogService.log(
        				LogService.ERROR,
        				"LDAPHandler:write() : impossible de trouver l'entree LDAP.");
				throw new FrameWorkException("erreur dans l'acquisition d'un attribut.");
			}
		}
	}
}
