/*
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a><br>
 * @version 1.0<br>
 */ 
package org.esupportail.portal.utils.channels;

import java.util.HashMap;

import org.apache.log4j.Priority;

/**
 * Action<br>
 * <br>
 * Cette classe dcrit une action que peut effectuer la channel<br>
 * Les actions de la channel sont rfrences dans une haspmap accessible  partir
 * de l'objet configActions de la classe principale du channel.<br>
 * Les actions sont lues  partir du fichier de configuration de la channel.<br> 
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 * 
 */
public class Action {

	public static final String RENDER_TYPE_SSL = "ssl";
	public static final String RENDER_TYPE_XSL = "xsl";
	public static final String DEFAULT_CACHE_TYPE = "default";
	public static final String INSTANCE_CACHE_TYPE = "instance";
	public static final String CHANNEL_CACHE_TYPE = "channel";
	
	private String name = null;
	private String type = "normal";
	private String classname = null;
	private String rendertype = RENDER_TYPE_XSL;
	private String sslfile = null;
	private String ssltitle = null;
	private String xslfile = null;
	private String init = "init";
	private String setoutput = "setOutput";
	private String setxml = "setXML";
	private String renderxml = "renderXML";
	private String servantfinish = null;
	private String servantinit = null;
	private Object param = null;
	private String cachetype = DEFAULT_CACHE_TYPE;
	private HashMap params =  new HashMap();
	private String log = "default";
	private Priority LogLevel;

	/**
	 * Ajout d'un paramtre  la liste
	 * @param param
	 */
	public void addActionParam(ActionParam param) {
		params.put(param.getName(), param);
	}
	
	/**
	 * Le nom de l'action
	 * @return Le nom de l'action
	 */
	public String getName() {
		return name;
	}

	/**
	 * Le type de l'action (normal ou servant / normal par dfaut)
	 * @return Le type de l'action (normal ou servant / normal par dfaut)
	 */
	public String getType() {
		return type;
	}

	/**
	 * Le nom complet de la classe  instancier pour l'action (DOIT ETRE UNIQUE pour une channel)
	 * @return Le nom complet de la classe  instancier pour l'action (DOIT ETRE UNIQUE pour une channel)
	 */
	public String getClassname() {
		return classname;
	}

	/**
	 * Le nom de la mthode d'initialisation de l'action (init par dfaut) 
	 * @return Le nom de la mthode d'initialisation de l'action (init par dfaut) 
	 */
	public String getInit() {
		return init;
	}

	/**
	 * Le type de rendu de l'action : xsl ou ssl (xsl par dfaut)
	 * @return Le type de rendu de l'action : xsl ou ssl (xsl par dfaut)
	 */
	public String getRenderType() {
		return rendertype;
	}

	/**
	 * Le nom de la mthode qui fait le rendu XML pour l'action (renderXML par dfaut)
	 * @return Le nom de la mthode qui fait le rendu XML pour l'action (renderXML par dfaut)
	 */
	public String getRenderXML() {
		return renderxml;
	}

	/**
	 * Le nom de la mthode qui fixe les paramtres de rendu xml (setOutput par dfaut)
	 * @return Le nom de la mthode qui fixe les paramtres de rendu xml (setOutput par dfaut)
	 */
	public String getSetOutput() {
		return setoutput;
	}

	/**
	 * Le nom de la mthode qui fixe le XML pour le rendu (setXML par dfaut)
	 * @return Le nom de la mthode qui fixe le XML pour le rendu (setXML par dfaut)
	 */
	public String getSetXML() {
		return setxml;
	}

	/**
	 * Le nom du fichier ssl  utiliser lorsque l'action est du type ssl (null par dfaut)
	 * @return Le nom du fichier ssl  utiliser lorsque l'action est du type ssl (null par dfaut)
	 */
	public String getSslFile() {
		return sslfile;
	}

	/**
	 * Le "title"  utiliser dans la feuille ssl lorsque l'action est du type ssl 
	 * @return Le "title"  utiliser dans la feuille ssl lorsque l'action est du type ssl 
	 */
	public String getSslTitle() {
		return ssltitle;
	}

	/**
	 * Le nom du fichier xsl  utiliser lorsque l'action est du type xsl (par dfaut getName() + ".xsl")
	 * @return Le nom du fichier xsl  utiliser lorsque l'action est du type xsl (par dfaut getName() + ".xsl")
	 */
	public String getXslFile() {
		return xslfile;
	}

	/**
	 * Le nom de l'action  initier lorsque le servant est termin
	 * @return Le nom de l'action  initier lorsque le servant est termin
	 */
	public String getServantfinish() {
		return servantfinish;
	}

	/**
	 * Le paramtre associ  l'action
	 * @return le paramtre associ  l'action
	 */
	public Object getParam() {
		return param;
	}

	/**
	 * Le type de cache
	 * @return 
	 */
	public String getCachetype() {
		return cachetype;
	}

	/**
	 * @return Returns the params.
	 */
	public HashMap getParams() {
		return params;
	}

	/**
	 * Positionnement du nom de la classe de l'action
	 * 
	 * @param string
	 */
	public void setClassname(String string) {
		classname = string;
	}

	/**
	 * Positionnement de la mthode d'initialisation de l'action
	 * 
	 * @param string
	 */
	public void setInit(String string) {
		init = string;
	}

	/**
	 * Positionnement du nom de l'action
	 * 
	 * @param string
	 */
	public void setName(String string) {
		name = string;
		if (ssltitle == null)
			ssltitle = name;
		if (xslfile == null)
			xslfile = name + "." + RENDER_TYPE_XSL;
	}

	/**
	 * Positionnement du type de rendu de l'action
	 * 
	 * @param string
	 */
	public void setRendertype(String string) {
		rendertype = string;
	}

	/**
	 * Positionnement du nom de la mthode qui assure le rendu XML pour l'action
	 * 
	 * @param string
	 */
	public void setRenderxml(String string) {
		renderxml = string;
	}

	/**
	 * Positionnement du nom de la mthode qui fixe les paramtres de rendu XML
	 * 
	 * @param string
	 */
	public void setSetoutput(String string) {
		setoutput = string;
	}

	/**
	 * Positionnement du XML  utiliser dans la transformation XSLT
	 * 
	 * @param string
	 */
	public void setSetxml(String string) {
		setxml = string;
	}

	/**
	 * Positionnement du nom du fichier ssl
	 * 
	 * @param string
	 */
	public void setSslfile(String string) {
		sslfile = string;
	}

	/**
	 * Positionnement du title  utiliser dans la feuille ssl
	 * 
	 * @param string
	 */
	public void setSsltitle(String string) {
		ssltitle = string;
	}

	/**
	 * Positionnement du nom du fichier xsl
	 * 
	 * @param string
	 */
	public void setXslfile(String string) {
		xslfile = string;
	}

	/**
	 * Positionnement du nom l'action  initier lorsque le servant est termin
	 * 
	 * @param string
	 */
	public void setServantfinish(String string) {
		servantfinish = string;
	}

	/**
	 * Positionnement du type de l'action (normal ou servant)
	 * 
	 * @param string
	 */
	public void setType(String string) {
		type = string;
	}

	/**
	 * Indique si l'action en cours est un servant
	 * 
	 * @return
	 */
	public boolean isServant() {
		return getType().equalsIgnoreCase("servant");
	}

	/**
	 * Positionne le paramtre associ  l'action
	 * @param 
	 */
	public void setParam(Object param) {
		this.param = param;
	}

	/**
	 * Positionne le type de cache
	 * @param 
	 */
	public void setCachetype(String cachetype) {
		this.cachetype = cachetype;
	}
	/**
	 * @return Returns the nivlog.
	 */
	public Priority getLogLevel() {
		return LogLevel;
	}
	/**
	 * @param log The log to set.
	 */
	public void setLog(String log) {
		this.log = log;
		if (log.equalsIgnoreCase("debug"))
			LogLevel = Priority.DEBUG;
		if (log.equalsIgnoreCase("info"))
			LogLevel = Priority.INFO;
		if (log.equalsIgnoreCase("error"))
			LogLevel = Priority.ERROR;
		if (log.equalsIgnoreCase("fatal"))
			LogLevel = Priority.FATAL;
	}
	/**
	 * @return Returns the log.
	 */
	public String getLog() {
		return log;
	}
	/**
	 * @param logLevel The logLevel to set.
	 */
	public void setLogLevel(Priority logLevel) {
		LogLevel = logLevel;
	}
	/**
	 * @return Returns the servantinit.
	 */
	public String getServantinit() {
		return servantinit;
	}
	/**
	 * @param servantinit The servantinit to set.
	 */
	public void setServantinit(String servantinit) {
		this.servantinit = servantinit;
	}
}
