/*
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a><br>
 * @version 1.0<br>
 */ 
package org.esupportail.portal.utils.channels;

import org.apache.log4j.Priority;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;

/**
 * ServantFactory<br>
 * <br>
 * "Usine" qui fabrique des Servant  la demande d'une MainChannel<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 * 
 */
public class ServantFactory {
	
	/**
	 * Mthode statique qui permet d'instancier une SubChannel correspondant  une action
	 * 
	 * @param mainChannel channel principale qui cherche  instancier une SubChannel
	 * @param action action pour laquelle on veut instancier la SubChannel
	 * @return la Servant correspondant  l'action
	 * @throws PortalException
	 */
	public static IServant instantiateServant(MainChannel mainChannel, Action action) throws PortalException {
		Class SubRenderXmlClass = null;
		Object SubRenderXmlObj = null;
		IServant res = null;
		
		if (action.getClassname() != null)
			// Instanciation du servant correspondant  l'action
			try {
				mainChannel.log("IServant::instantiateServant() : Tentative d'instanciation du servant " + action.getClassname());
				SubRenderXmlClass = Class.forName(action.getClassname());
				// Instanciation du servant
				SubRenderXmlObj = SubRenderXmlClass.newInstance();
				res = (IServant)SubRenderXmlObj;
				mainChannel.log("IServant::instantiateServant() : instanciation du servant " + action.getClassname() + " russie !");
				// Initialisation du servant
				mainChannel.initServant(res);
				mainChannel.log("IServant::instantiateServant() : initialisation du servant russie !");
			}
			catch (Exception e) {
				res = null;
				mainChannel.log(Priority.ERROR, "IServant::instantiateServant() : Echec de l'instanciation du servant : " + action.getClassname() + 
						"\n" + MainChannel.stack2string(e));
				throw new PortalException("Echec de l'instanciation du servant :  " + action.getClassname() +  
						" voir le log uportal");
			}
		return res;
	}

}
