package org.esupportail.portal.utils.channels.plugins;

/**
 * MessageBean<br>
 * <br>
 * Classe permettant de manipuler un couple message / type de message<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.0
 * 
 */
public class MessageBean {
    
    private String message = null;
    private int type = Message.ERROR;
    
    /**
     * Constructeur
     */
    public MessageBean() {
    }
    
    /**
     * Constructeur
     * @param message Le contenu du message
     */
    public MessageBean(String message) {
        this.message = message;
    }
    
    /**
     * Contructeur
     * @param message Le contenu du message
     * @param type Le type du message (Message.ERROR, Message.WARNING, Message.INFO)
     */
    public MessageBean(String message, int type) {
        this.message = message;
        this.type = type;
    }
    
    /**
     * Le contenu du message
     * @return
     */
    public String getMessage() {
        return message;
    }
    
    /**
     * Les contenu du message
     * @param message
     */
    public void setMessage(String message) {
        this.message = message;
    }
    
    /**
     * Le type du message
     * @return
     */
    public int getType() {
        return type;
    }
    
    /**
     * Le type du message
     * @param type
     */
    public void setType(int type) {
        this.type = type;
    }

    public String toXMLString() {
        String type = null;
        switch(this.type) {
        	case Message.ERROR : type = "ERROR";break;
        	case Message.WARNING : type = "WARNING";break;
        	case Message.INFO : type = "INFO";break;
        	default : type = "ERROR";break;
        }
        return "<message type=\"" + type + "\" message=\"" + message + "\" />\n"; 
    }
}
