package org.esupportail.portal.utils.channels;

import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.PortalException;
import org.xml.sax.ContentHandler;

/**
 * ISubChannel<br>
 * <br>
 * Interface dcrivant les mthodes que doit implmenter une sous-channel (SubChannel)<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version $Revision: 1.1 $
 */

public interface ISubChannel extends ICacheable {

	/**
	 * Retourne le XML  utiliser lors de l'affichage
	 * @return
	 */
	public String getXML();

	/**
	 * Retourne le fichier XSL  utiliser lors de l'affichage
	 * @return
	 */
	public String getXSL(); 

	/**
	 * Retourne le fichier SSL  utiliser lors la transformation XSLT
	 * @return
	 */
	public String getSSL();

	/**
	 * Retourne les paramtres  passer  la feuille XSL
	 * @return
	 */
	public Hashtable getXSLParameter(); 

	/**
	 * Positionne la valeur du XML
	 * @param xml
	 */
	public void setXML(String xml) throws FrameWorkException;

	/**
	 * Positionne la valeur du fichier XSL
	 * @param xsl
	 */
	public void setXSL(String xsl);

	/**
	 * Positionne la feuille SSL (null si pas de feuille ssl)
	 * @param ssl
	 */
	public void setSSL(String ssl);

	/**
	 * Positionne les paramtres de la feuille XSL
	 * @param h
	 */
	public void setXSLParameter(Hashtable h);

	/**
	 * Dans le cycle de vie d'une SubChannel, intervient en tout premier, juste aprs l'instanciation
	 * @param rd Les RuntimeData de la channel principale (MainChannel)
	 * @return Indique si le cycle de vie peut se poursuivre (passer  setXML)
	 * @throws PortalException
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException;
	
	/**
	 * Dans le cycle de vie d'une sous-channel, mthode qui est appele aprs init
	 * @return Une russite (ou non) qui indique si le cycle de vie se poursuit (passer  setOutput)
	 */
	public Boolean setXML() throws FrameWorkException;

	/**
	 * Avant-derniere mthode appele lors du cycle de vie d'une sous-channel
	 * Permet de positionner le nom du fichier xsl ou ssl 
	 */
	public void setOutput() throws FrameWorkException;
	
	/**
	 * Fait le rendu XML.
	 * Le moins de traitement doit tre fait ici.
	 * @param out
	 * @throws PortalException
	 */
	public void renderXML(ContentHandler out) throws PortalException;
	
	/**
	 * Mthode appelle lorsque la channel est rutilise.
	 * Permet d'initialiser certaines donnes entre 2 utilisations (les paramtres XSL par exemple)
	 */
	public void clearChannel();
	
	/**
	 * Log d'un message dans le fichier uportal.log au niveau par dfaut
	 * @param logMessage
	 * @deprecated
	 */
	public void log(String logMessage);
	
	/**
	 * Log d'un message selon un niveau de priorit
	 * @param level
	 * @param logMessage
	 * @deprecated
	 */
	public void log(Priority level, String logMessage);
}
