package org.esupportail.portal.utils.channels.plugins;

import java.util.Enumeration;
import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XMLEscaper;

/**
 * Confirm<br>
 * <br>
 * Ce plugin ajoute une action permettant de demander une confirmation<br>
 * Soit le rsultat du choix de l'utilisateur est transmis  une action qui agit en consquence,<br>
 * soit le plugin appelle des actions diffrents en fonction du choix de l'utilisateur
 * Une liste de paramtres  transmettre  l'action suivante peut galement tre ajoute<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.2 $
 */

public class Confirm extends SubChannel {
	
	protected static Log logguer = LogFactory.getLog(Confirm.class);
	
	private static String plugNameForm = "plug.esup.confirm.form";
	private static String plugNameProc = "plug.esup.confirm.proc";
	
	private int mode = 0;
	private String actionYes = null;
	private String actionNo = null;
	private Hashtable parametersYes = null;
	private Hashtable parametersNo = null;
	
	/**
	 * Constructeur
	 * @param main Channel principale
	 */
	public Confirm(MainChannel main) {
		super(main);
		if(logguer.isDebugEnabled()) {
		    logguer.debug("Confirm::Confirm()");
		}
	}
	
	/**
	 * Mthode statique qui permet d'enregistrer le plug-in error confirm dans la liste des actions d'un channel
	 * @param main Channel principale
	 */
	public static void register(MainChannel main) {
		// Action d'affichage du formulaire
	    Action action = new Action();
		action.setName(plugNameForm);
		action.setClassname("org.esupportail.portal.utils.channels.plugins.Confirm");
		action.setXslfile("confirm.xsl");
		main.getConfigActions().getActions().put(action.getName(), action);
		
		// Action de traitement du formulaire
		action = new Action();
		action.setName(plugNameProc);
		action.setClassname("org.esupportail.portal.utils.channels.plugins.Confirm");
		action.setInit("procinit");
		main.getConfigActions().getActions().put(action.getName(), action);
	}
	
	/**
	 * Mthode statique qui permet d'afficher un message de confirmation<br>
	 * C'est l'action suivant qui traite si l'utilisateur a cliqu sur<br>
	 * oui ou sur non en testant la variable _confirm des runtimeData
	 * @param main Channel principale
	 * @param rd Les runtimeData
	 * @param msg Le message de confirmation  afficher
	 * @param confAction L'action destinataire de la confirmation
	 * @throws PortalException
	 */
	public static void confirm(MainChannel main, ChannelRuntimeData rd, String msg, String confAction) throws PortalException {
	    rd.setParameter("_mode", "1");
	    rd.setParameter("_msg", msg);
	    rd.setParameter("_action", confAction);
	    rd.setParameter("action", plugNameForm);
	    main.setRuntimeData(rd);
	}
	
	/**
	 * Mthode statique qui permet d'afficher un message de confirmation<br>
	 * C'est l'action suivant qui traite si l'utilisateur a cliqu sur<br>
	 * oui ou sur non en testant la variable _confirm des runtimeData<br>
	 * Les paramtres fournis sont transmis  l'action suivante
	 * @param main Channel principale
	 * @param rd Les runtimeData
	 * @param msg Le message de confirmation  afficher
	 * @param confAction L'action destinataire de la confirmation
	 * @param parameters Les paramtres  transmettre  l'action suivante
	 * @throws PortalException
	 */
	public static void confirm(MainChannel main, ChannelRuntimeData rd, String msg, String confAction, Hashtable parameters) throws PortalException {
	    rd.setParameter("_mode", "2");
	    rd.setParameter("_msg", msg);
	    rd.setParameter("_action", confAction);
	    rd.put("_parameters", parameters);
	    rd.setParameter("action", plugNameForm);
	    main.setRuntimeData(rd);
	}
	
	/**
	 * Mthode statique qui permet d'afficher un message de confirmation<br>
	 * Si l'utilisateur clique sur Oui, c'est l'actionYes qui est excute<br>
	 * Sinon c'est l'actionNo
	 * @param main Channel principale
	 * @param rd Les runtimeData
	 * @param msg Le message de confirmation  afficher
	 * @param actionYes L'actionYes
	 * @param actionNo L'actionNo
	 * @throws PortalException
	 */
	public static void confirm(MainChannel main, ChannelRuntimeData rd, String msg, String actionYes, String actionNo) throws PortalException {
	    rd.setParameter("_mode", "3");
	    rd.setParameter("_msg", msg);
	    rd.setParameter("_actionyes", actionYes);
	    rd.setParameter("_actionno", actionNo);
	    rd.setParameter("action", plugNameForm);
	    main.setRuntimeData(rd);
	}
	
	/**
	 * Mthode statique qui permet d'afficher un message de confirmation<br>
	 * Si l'utilisateur clique sur Oui, c'est l'actionYes qui est excute<br>
	 * Sinon c'est l'actionNo<br>
	 * Les paramtres fournis sont transmis indifremment  l'action suivante
	 * @param main Channel principale
	 * @param rd Les runtimeData
	 * @param msg Le message de confirmation  afficher
	 * @param actionYes L'actionYes
	 * @param actionNo L'actionNo
	 * @param parameters Les paramtres  transmettre  l'action suivante
	 * @throws PortalException
	 */
	public static void confirm(MainChannel main, ChannelRuntimeData rd, String msg, String actionYes, String actionNo, Hashtable parameters) throws PortalException {
	    rd.setParameter("_mode", "4");
	    rd.setParameter("_msg", msg);
	    rd.setParameter("_actionyes", actionYes);
	    rd.setParameter("_actionno", actionNo);
	    rd.put("_parameters", parameters);
	    rd.setParameter("action", plugNameForm);
	    main.setRuntimeData(rd);
	}
	
	/**
	 * Mthode statique qui permet d'afficher un message de confirmation<br>
	 * Si l'utilisateur clique sur Oui, c'est l'actionYes qui est excute<br>
	 * Sinon c'est l'actionNo<br>
	 * De la mme faon, parametersYes sont transmis  l'actionYes et<br>
	 * parametersNo sont transmis  l'actionNo
	 * @param main Channel principale
	 * @param rd Les runtimeData
	 * @param msg Le message de confirmation  afficher
	 * @param actionYes L'actionYes
	 * @param actionNo L'actionNo
	 * @param parametersYes
	 * @param parametersNo
	 * @throws PortalException
	 */
	public static void confirm(MainChannel main, ChannelRuntimeData rd, String msg, String actionYes, String actionNo, Hashtable parametersYes, Hashtable parametersNo) throws PortalException {
	    rd.setParameter("_mode", "5");
	    rd.setParameter("_msg", msg);
	    rd.setParameter("_actionyes", actionYes);
	    rd.setParameter("_actionno", actionNo);
	    rd.put("_parametersyes", parametersYes);
	    rd.put("_parametersno", parametersNo);
	    rd.setParameter("action", plugNameForm);
	    main.setRuntimeData(rd);
	}
	
    /**
     * Initialisation du plugin
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        mode = new Integer(runtimeData.getParameter("_mode")).intValue();
        return Boolean.TRUE;
    }
    
	/**
	 * Positionnement du XML pour le plug-in
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() throws FrameWorkException {
	    if(logguer.isDebugEnabled()) {
		    logguer.debug("Confirm::setXML()");
	    }
		StringBuffer xml = new StringBuffer();
		xml.append("<msg value=\"" + XMLEscaper.escape(runtimeData.getParameter("_msg")) + "\" />\n");
		switch(mode) {
			case 1: {
			    xml.append("<action name=\"" + runtimeData.getParameter("_action") + "\" />\n");
			    break;
			}
			case 2: {
			    xml.append("<action name=\"" + runtimeData.getParameter("_action") + "\" />\n");
			    xml.append("<parameters>\n");
			    Hashtable parameters = (Hashtable)runtimeData.get("_parameters");
			    Enumeration keys = parameters.keys();
			    while(keys.hasMoreElements()) {
					String key = (String)keys.nextElement();
					String value = (String)parameters.get(key);
					xml.append("<parameter name=\"" + key + "\" value=\"" + value + "\" />\n");
				}
			    xml.append("</parameters>\n");
			    break;
			}
			case 3: {
			    actionYes = runtimeData.getParameter("_actionyes");
			    actionNo = runtimeData.getParameter("_actionno");
			    xml.append("<action name=\"" + plugNameProc + "\" />\n");
			    break;
			}
			case 4: {
			    actionYes = runtimeData.getParameter("_actionyes");
			    actionNo = runtimeData.getParameter("_actionno");
			    parametersYes = (Hashtable)runtimeData.get("_parameters");
			    xml.append("<action name=\"" + plugNameProc + "\" />\n");
			    break;
			}
			case 5: {
			    actionYes = runtimeData.getParameter("_actionyes");
			    actionNo = runtimeData.getParameter("_actionno");
			    parametersYes = (Hashtable)runtimeData.get("_parametersyes");
			    parametersNo = (Hashtable)runtimeData.get("_parametersno");
			    xml.append("<action name=\"" + plugNameProc + "\" />\n");
			    break;
			}
		}
		this.xml = xml.toString();
		return Boolean.TRUE;
	}
	
	/**
     * Traitement du formulaire
     */
    public Boolean procinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        String conf = runtimeData.getParameter("_confirm");
        if(conf == null) {
            conf = "Non";
        }
        if(conf.equals("Oui")) {
            switch(mode) {
            	case 3: {
            	    mainChannel.redirect(runtimeData, actionYes);
            	    break;
            	}
            	case 4: 
            	case 5: {
            	    Enumeration keys = parametersYes.keys();
    			    while(keys.hasMoreElements()) {
    					String key = (String)keys.nextElement();
    					String value = (String)parametersYes.get(key);
    					runtimeData.setParameter(key, value);
    				}
    			    mainChannel.redirect(runtimeData, actionYes);
    			    break;
            	}
            }
        }
        else {
            switch(mode) {
        		case 3: {
        		    mainChannel.redirect(runtimeData, actionNo);
        		    break;
        		}
        		case 4: {
        		    Enumeration keys = parametersYes.keys();
        		    while(keys.hasMoreElements()) {
        		        String key = (String)keys.nextElement();
        		        String value = (String)parametersYes.get(key);
        		        runtimeData.setParameter(key, value);
        		    }
        		    mainChannel.redirect(runtimeData, actionNo);
        		    break;
        		}
        		case 5: {
        		    Enumeration keys = parametersNo.keys();
        		    while(keys.hasMoreElements()) {
        		        String key = (String)keys.nextElement();
        		        String value = (String)parametersNo.get(key);
        		        runtimeData.setParameter(key, value);
        		    }
        		    mainChannel.redirect(runtimeData, actionNo);
        		    break;
        		}
            }
        }
        return Boolean.FALSE;
    }
}