package org.esupportail.portal.utils.channels.plugins;

import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;

/**
 * Ce plug-in ajoute une page qui permet d'afficher un message d'erreur fatale<br> 
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version $Revision: 1.1 $
 */

public class FatalError extends SubChannel {

	/**
	 * Constructeur
	 * @param main
	 */
	public FatalError(MainChannel main) {
		super(main);
	}
	
	/**
	 * Mthode statique qui efface toutes les actions pour ne laisser que 
	 * le plug-in d'erreur fatale comme page par dfaut ( faire avant le setruntimedata)
	 * @param main channel principale
	 * @param msg Message d'erreur
	 */
	public static void fatalError(MainChannel main, String msg) {
		main.getConfigActions().getActions().clear();

		Action action = new Action();
		action.setName("default");
		action.setClassname(FatalError.class.getName());
		action.setXslfile("fatalerror.xsl");
		action.setParam(msg);
		main.getConfigActions().getActions().put(action.getName(), action);
	}

	/**
	 * Positionnement du XML pour le plug-in
	 * @return toujours Boolean.TRUE
	 */
	public Boolean setXML() throws FrameWorkException {
		String xml = null;
		xml += "<MESSAGE>" + (String)getMainChannel().getCurrentAction().getParam() + "</MESSAGE>";
		setXML(xml);
		return Boolean.TRUE;
	}
}