package org.esupportail.portal.utils.channels.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.ActionParam;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.jasig.portal.PortalException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;

/**
 * RestrictedAction<br>
 * <br>
 * Ce plug-in ajoute n'est pas un vritable plugin au sens MAG.
 * C'est  dire qu'il n'est pas ncessaire de faire un "register" 
 * et qu'il n'y a pas de prise en charge d'affichage.<br>
 * L'interet de cette clase est de fournir une mthode statique pour 
 * filtrer l'accs d'une personne  une action.<br>
 * De plus cette classe met dans les staticData le groupe reconnu.
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:sebastien.gaudin@univ-nancy2.fr">Sbastien Gaudin</a>
 * @version $Revision: 1.1 $
 * 
 */
public class RestrictedAction extends SubChannel {

	protected static Log logguer = LogFactory.getLog(RestrictedAction.class);
    
    private static String plugName = "plug.esup.restrictedAction";
	
	/**
	 * Constructeur
	 * @param main
	 */
	public RestrictedAction(MainChannel main) {
		super(main);
	}
	
	/**
	 * Appel de la mthode filterAccess en autorisant l'accs
	 * aux actions sans dclaration de groupe
	 * @param main la mainchannel
	 * @param currentAction le nom de l'action en cours
	 * @param mapping le mapping des groupes
	 */
	public static boolean filterAccess(MainChannel main,String currentAction,HashMap mapping) throws PortalException,FrameWorkException {
		return filterAccess(main,currentAction,mapping, true);
	}		 
	
	/**
	 * Mthode statique qui permet de filtrer l'accs sur l'action en cours
	 * par rapport aux groupes auquel appatient la personne connecte
	 * @param main la mainchannel
	 * @param currentAction le nom de l'action en cours
	 * @param mapping le mapping des groupes
	 * @param allowWithoutGroupSpecification l'autorisation d'accs en cas de non dclaration de groupe
	 */
	public static boolean filterAccess(MainChannel main,String currentAction,HashMap mapping,boolean allowWithoutGroupSpecification) throws PortalException,FrameWorkException {
		
	    if(logguer.isDebugEnabled()) {
	        logguer.debug("RestrictedAction::filterAccess() : Action courante : " + currentAction);
	    }
	    ActionParam paramGroup = main.getActionParam(currentAction,plugName);
		
		// Si aucun groupe n'est prcis dans la configuration et que l'on autorise tout le monde
		if((paramGroup==null) && (allowWithoutGroupSpecification)) {
		    if(logguer.isDebugEnabled()) {
		        logguer.debug("RestrictedAction::filterAccess() : Action sans restriction d'acc\u00E8s");
		    }
		    return true;
		}
		
		if(logguer.isDebugEnabled()) {
	        logguer.debug("RestrictedAction::filterAccess() : Action avec restriction d'acc\u00E8s");
		}
		
		List  listGroup = new ArrayList();
		
		if(paramGroup!=null ) {
		    // Les groupes autoriss sont ceux dclars pour le groupe
		    listGroup = paramGroup.getValues();
		}
		else {
		    // Les groupes autoriss sont tous les groupes dclars
		    listGroup.addAll((Collection)mapping.keySet());
		}

		if(main.getStaticData().get(plugName)!=null) {
			// On connait le groupe d'appartenance de la personne connecte
			// On cherche si ce groupe est autoris  accder  l'action en cours
			Iterator j = listGroup.iterator();
			/*... on recherche la cl...*/
			while(j.hasNext()) {  
				String localNameGroup = (String)j.next();
				if (localNameGroup.equals(main.getStaticData().get(plugName))){
				    if(logguer.isDebugEnabled()) {
				        logguer.debug("RestrictedAction::filterAccess() : Groupe autoris\u00E9 : " + main.getStaticData().get(plugName));
				    }
			    	return true;
		        }
			}
			return false;
		}
		
		// On ne connait pas le groupe d'apartenance de la personne connecte	
		IEntity user = null;
		String login = (String)main.getStaticData().getPerson().getAttribute(IPerson.USERNAME);
		user = GroupService.getEntity(login, org.jasig.portal.security.IPerson.class);
		
		if(user != null) {  
		    Iterator groupsTest;
	        groupsTest = user.getAllContainingGroups();
	        // Parcours des groupes de la personne connecte
			while(groupsTest.hasNext()) {  
				IGroupMember groupTmp = (IGroupMember)groupsTest.next(); 
	              
				Iterator j = listGroup.iterator();
				// Parcours des groupes autoriss pour l'action en cours
				while(j.hasNext()) {  
					String localNameGroup = (String)j.next();
					if (mapping.get(localNameGroup).equals(groupTmp.getKey())){
					    if(logguer.isDebugEnabled()) {
					        logguer.debug("RestrictedAction::filterAccess() : Groupe trouv\u00E9 : " + groupTmp.getKey() + " (" + localNameGroup + ")");
					    }
				    	main.getStaticData().put(plugName,localNameGroup);
				    	return true;
				    }
				}
			}   
				
			if(logguer.isDebugEnabled()) {
		        logguer.debug("RestrictedAction::filterAccess() : Aucun groupe trouv");
			}
		   	return false;
		}  
	    else {  
	        if(logguer.isDebugEnabled()) {
		        logguer.debug("RestrictedAction::filterAccess() : Utilisateur " + login + " in\u00E9xistant");
	        }
	        throw new FrameWorkException("RestrictedAction::filterAccess() : Utilisateur " + login + " in\u00E9xistant");
	    }
	}
}