/**
 * Classe utilitaire pour les accs base de donnesClasse utilitaire pour les accs base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="http://mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version $Revision: 1.1 $
 */

package org.esupportail.portal.utils.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.RDBMServices;

/**
 * Classe d'abstraction pour accs aux base de donnes.
 * L'objectif est de simplifier les accs les plus courants  la librairie JDBC et 
 * de centraliser les exceptions qu'elles peuvent soulever.
 */
public class Query {
	
	protected static Log logguer = LogFactory.getLog(Query.class);
    
    private Connection con = null;
	private RDBMServices.PreparedStatement statement = null;
	private ResultSet resultset = null;
	private String sql = null;
	private static final String PREFIX = "__";
	private boolean debug = false;
 	private boolean autoCommit = true;
	private String type;
	private int isolation = Connection.TRANSACTION_READ_COMMITTED;
	
	/**
	 * Constructeur 
	 * @deprecated
	 * @param pool pool de connexion  utiliser pour la requte
	 */
	public Query(String pool) {
		setCon(RDBMServices.getConnection(pool));
	}
	
	/**
	 * Constructeur 
	 * @param db objet database  utiliser pour la requte
	 */
	public Query(Database db) throws SQLException {
		if (db != null) {
			setCon(db);
		}
		else {
			logguer.error("Query::Query() : Objet Database vide");
			throw new SQLException();
		}	
	}
	
	/**
	 * Fermeture de la requete : resultset, statement et connexion
	 */
	public Exception close() {
		Exception res = null;
		try {
			closeRs();
		}
		catch (Exception e) {
				res = e;
				logException(e, "close resultset");
		}
		try {
			closeStmt();
		}
		catch (Exception e) {
			res = e;
			logException(e, "close statement");
		}
		try {
			if (getCon() != null) {
				if (type.equals("JNDI")) 
					RDBMServices.releaseConnection(getCon());
				else 
					getCon().close();
			}
		}
		catch (Exception e) {
			res = e;
			logException(e, "close connection");
		}
		return res;
	}
	
	/**
	 * Fermeture du resultset associ  l'objet
	 * @throws SQLException
	 */
	private void closeRs() throws SQLException {
		if (getRs() != null) {
			getRs().close();
		}
	}
	
	/**
	 * Fermeture du statement associ  l'objet
	 * @throws SQLException
	 */
	private void closeStmt() throws SQLException {
		if (getStmt() != null) {
			getStmt().close();
		}
	}
	/**
	 * rcupre la connexion associe  l'objet
	 */
	private Connection getCon() {
		return con;
	}

	/**
	 * rcupre le resultset associ  l'objet
	 */
	public ResultSet getRs() {
		return resultset;
	}

	/**
	 * retourne le statement associ  l'objet
	 */
	public RDBMServices.PreparedStatement getStmt() {
		return statement;
	}

	/**
	 * Log les exceptions
	 * 
	 * @param exception
	 * @param comment commentaire  afficher dans le log
	 */
	private void logException(Exception exception, String comment) {
		logguer.error("Query:logExeception() : " + comment + "(" + exception.getMessage() + ")");
	}

	/**
	 * rcupre le sql de l'objet
	 */
	private String getSql() {
		return sql;
	}

	/**
	 * Positionnement de la requte SQL de l'objet
	 * @param sql
	 * @throws SQLException
	 */
	public void setSql(String sql) throws SQLException {
		this.sql = sql;
		// Fermeture ventuelle de la requte en cours
		closeRs();
		closeStmt();
		// Puis ouverture
		setStmt(new RDBMServices.PreparedStatement(getCon(), sql));
		statement.clearParameters();
	}
	
	/**
	 * Positionne le sql en positionnant un prfixe devant les tables de la requte
	 * @param sql requte SQL
	 * @param prefix prfixe  ajouter en lieu et place de __
	 * @throws SQLException
	 */
	public void setSql(String sql, String prefix) throws SQLException {
		setSql(sql.replaceAll(PREFIX,prefix));
	}

	/**
	 * Ouverture de la requte
	 * @throws SQLException
	 */
	public void select() throws SQLException {
		if (getStmt() == null)
			throw new SQLException("select : le statement est null");
		setRs(getStmt().executeQuery());
	}

	/**
	 * Commit
	 */
	public void commit() {
		try {
			con.commit();	
		}
		catch (SQLException e) {
		    logException(e, "commit");
		}
	}
	
	/**
	 * rollback
	 */
	public void rollback() {
		try {
			con.rollback();	
		}
		catch (SQLException e) {
		    logException(e, "rollback");
		}
	}
	
	/**
	 * Execution d'un ordre SQLs
	 * @param mode : insert/delete/update (ne sert que pour les logs)
	 * @return
	 * @throws SQLException
	 */
	private int execSql(String mode) throws SQLException {
		if(!autoCommit) {
			con.setAutoCommit(false);
			con.setTransactionIsolation(isolation);
		}
		if (getStmt() == null)
			throw new SQLException(mode + " : le statement est null");
		int res = (getStmt().executeUpdate());
		return res;
	}
	
	/**
	 * Insertion
	 * @throws SQLException
	 */
	public int insert() throws SQLException {
		return execSql("insert");
	}
	
	/**
	 * Delete
	 * @throws SQLException
	 */
	public int delete() throws SQLException {
		return execSql("delete");
	}
	
	/**
	 * Update
	 * @throws SQLException
	 */
	public int update() throws SQLException {
		return execSql("update");
	}
	
	/**
	 * Positionnement de la requte et ouverture de celle-ci en une opration
	 * @param sql requte sql
	 * @throws SQLException
	 */
	public void select(String sql) throws SQLException {
		setSql(sql);
		select();
	}
	
	/**
	 * Postionnement de la connexion de l'objet
	 * @param connection
	 */
	private void setCon(Connection connection) {
		con = connection;
		type = "JNDI";
	}
	
	/**
	 * Postionnement de la connexion de l'objet
	 * @param db objet Database
	 */
	private void setCon(Database db) {
		// cas pool Tomcat			
		if (db.getType().toUpperCase().equals("JNDI")) {
			con = RDBMServices.getConnection(db.getUrl());
			if (con == null) {
				logguer.error("Query::setCon(Database) : connexion vide");
			}	
			type = "JNDI";
		} // cas JDBC simple
		else if (db.getType().toUpperCase().equals("JDBC")) {
			type = "JDBC";
			createConnection(db);
			// Si l'objet connexion n'est pas null mais qu'il n'est plus valide, on le recre		
			try{
				if(con.isClosed()){
					createConnection(db);
				}
			}
			catch(SQLException e){
			    logguer.error("Query::setCon() Erreur de connexion \u00E0 l'url : " + db.getUrl() + ";" + e);
			}				
		}
		else { // pas de type prcis
		    logguer.error("Query::setCon() Erreur de connexion \u00E0 l'url : " + db.getUrl() + "; Pas de type de connexion pr\u00E9cis\u00E9");
		}
	}
	
	/**
	 * Cration d'une connexion JDBC 
	 * @param db objet database
	 */
	private void createConnection(Database db){
		try{
			Class.forName(db.getDriverClassName()).newInstance();
			con = DriverManager.getConnection(db.getUrl(),db.getUsername(),db.getPassword());
			String key = db.getDriverClassName()+":"+db.getUrl()+":"+db.getUsername()+":"+db.getPassword();
			if (con == null){
			    logguer.error("Query::createConnection() Erreur de connexion \u00E0 l'url : " + db.getUrl());
			}
		}
		catch(Exception e){
		    logguer.error("Query::createConnection() Erreur de connexion \u00E0 l'url : " + db.getUrl() + ";" + e);
		}
	}

	/**
	 * @param set
	 */
	private void setRs(ResultSet resultset) {
		this.resultset = resultset;
	}

	/**
	 * @param statement
	 */
	private void setStmt(RDBMServices.PreparedStatement statement) {
		this.statement = statement;
	}
	
	/**
	 * l'autocommit est-il actif ?
	 * @return
	 */
	public boolean isAutoCommit() {
		return autoCommit;
	}

	/**
	 * Positionnement de l'autocommit
	 * @param autocommit
	 */
	public void setAutoCommit(boolean autocommit) {
		this.autoCommit = autocommit; 
	}

	/**
	 * Retourne une chaine entre '
	 * @param s chaine  mettre entre '
	 * @return
	 */
	public static String quotedStr(String s) {
		return "'" + s + "'";
	}
	
	public void setTransactionIsolation(int level) {
		isolation = level;
	}
}