package org.esupportail.portal.utils.channels;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/**
 * Mail<br>
 * <br>
 * Classe permet d'envoyer des mails<br> 
 * <br>
 * (c)Copyright <a href="http://www.univ-nancy2.fr">CRI Nancy 2 2004</a><br>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 * 
 */
public class Mail {

 	private IConfigMail configMail;
 	private String from;
	private String to;
	private String subject;
	private String message;
	private String smtp;

	/**
	 * Constructeur
	 * @param conf un objet implmentant l'interface IConfig
	 */
	public Mail(IConfigMail conf) {
	  configMail = conf;
	  this.setFrom(configMail.getFrom());
	  this.setTo(configMail.getTo());
	  this.setSubject(configMail.getSubject());
	  this.setMessage(configMail.getMessage());
	  this.setSmtp(configMail.getSmtp());
	}
	
	/**
	 * Positionne l'expditeur du message
	 * @param from
	 */
	public void setFrom(String from){
		this.from = from;
	}
	
	/**
	 * Positionne le destinataire du message
	 * @param to
	 */
	public void setTo(String to){
	  this.to = to;
	}
	
	/**
	 * Positionne le sujet du message
	 * @param subject
	 */
	public void setSubject(String subject) {
	  this.subject = subject;
	}
	
	/**
	 * Positionne le contenu du message
	 * @param message
	 */
	public void setMessage(String message) {
	  this.message = message;
	}
	
	/**
	 * Retourne le contenu du message
	 * @return
	 */
	public String getMessage() {
	  return message;
	}
	
	/**
	 * Retourne le sujet du message
	 * @return
	 */
	public String getSubject() {
	  return subject;
	}
	
	/**
	 * Retourne le destinataire
	 * @return
	 */
	public String getFrom() {
		return from;
	}
	
	/**
	 * Retourne le destinataire 
	 * @return
	 */
	public String getTo() {
	  return to;
	}
	
	/**
	 * Retourne le serveur SMTP
	 * @return
	 */
	public String getSmtp() {
		return smtp;
	}
	
	/**
	 * Envoie l'e-mail
	 * @param fich liste contenant les fichiers joints de classe java.io.File
	 * @throws Exception
	 */
	public void send(Vector fich) throws Exception {
		smtp = configMail.getSmtp();
		
		Properties props = System.getProperties(); // Obtenir les proprits du system de la machine cliente
		props.put("mail.smtp.host", smtp);
		// Ajouter le nom du serveur SMTP aux proprits
		Session session = Session.getDefaultInstance(props, null);// Obtenir un objet session bas sur les proprits
		MimeMessage message = new MimeMessage(session);// Crer un MimeMessage bas sur la session
		message.setFrom(new InternetAddress(this.getFrom()));// dfinir ladresse de lexpditeur du message
		message.addRecipient(Message.RecipientType.TO, new InternetAddress(this.getTo()));// dfinir ladresse du destinataire du message
		message.setSubject(this.getSubject());// dfinir le sujet du message
		
		// Create the message part
		BodyPart messageBodyPart = new MimeBodyPart();
		
		// Fill the message
		messageBodyPart.setText(this.getMessage());
		messageBodyPart.setContent(this.getMessage(), "text/html"); 

		Multipart multipart = new MimeMultipart();
		multipart.addBodyPart(messageBodyPart);
		
		// Attache les fichiers joints
		if(fich!=null){
		    Enumeration enum = fich.elements();
		    while(enum.hasMoreElements()){
				File fd= (File)enum.nextElement();
				messageBodyPart = new MimeBodyPart();
				javax.activation.DataSource source = new FileDataSource(fd);
				messageBodyPart.setDataHandler(new DataHandler(source));
				messageBodyPart.setFileName(fd.getName());
				multipart.addBodyPart(messageBodyPart);
		    }
		  }
		
		// Attache au message
		message.setContent(multipart);
		// envoie du message
		Transport.send(message);
	}
	
	/**
	 * Positionne le serveur SMTP
	 * @param string
	 */
	public void setSmtp(String string) {
		smtp = string;
	}

}