package org.esupportail.portal.utils.channels.plugins;

import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * Todo<br>
 * <br>
 * Ce plug-in ajoute une page qui permet d'afficher un message qui dit que la fonctionnalit reste  dvelopper<br>
 * Utile pour mettre en place rapidement le squelette d'une application avec toutes ses actions mmes si elles
 * ne sont pas encore dveloppes<br> 
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version $Revision 2.0 $
 */

public class Todo extends SubChannel {

	static private String plugName = "plug.esup.todo";
	
	/**
	 * Constructeur
	 * @param main
	 */
	public Todo(MainChannel main) {
		super(main);
	}
	
	/**
	 * Mthode statique qui permet d'enregistrer le plug-in Todo dans la liste des actions d'une channel
	 * @param main Channel principale de l'application
	 */
	public static void register(MainChannel main) {
		Action action = new Action();
		
		action.setName(plugName);
		action.setClassname(Todo.class.getName());
		action.setXslfile("todo.xsl");
		action.setCachetype(Action.INSTANCE_CACHE_TYPE); //  CHANNEL_CACHE_TYPE
		main.getConfigActions().getActions().put(action.getName(), action);
	}
	
	/**
	 * Mthode statique qui permet d'afficher la page du plug-in
	 * @param main channel principale
	 * @param rd runtimeData
	 * @param newAction action sur laquelle aller lors du clic sur "OK"
	 * @throws PortalException
	 */
	public static void todo(MainChannel main, ChannelRuntimeData rd, String newAction) throws PortalException {
		rd.setParameter("_ACTION",newAction);
		rd.setParameter("action", plugName);
		main.setRuntimeData(rd);	
	}

	/**
	 * Positionnement du XML pour le plug-in
	 * @return toujours Boolean.TRUE
	 */
	public Boolean setXML() throws FrameWorkException {
		String xml = "<ACTION>" + getRuntimeData().getParameter("_ACTION") + "</ACTION>";
		setXML(xml);
		return Boolean.TRUE;
	}
}