/**
 * Classe modlisant un accs JNDI/JDBC<br> 
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version $Revision: 1.1 $
 */

package org.esupportail.portal.utils.database;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Classe modlisant un accs JDBC
 * Utilise par la classe Query
 */
public class Database {

	protected static Log logguer = LogFactory.getLog(Database.class);
    
    private String type;
	private String driverClassName;
	private String url;
	private String username;
	private String password;
	private String name;
	
	/**
	 * Constructeur 
	 */
	public Database () {
	}
	
	/**
	 * Constructeur 
	 * @param type type de connexion JDBC ou JNDI
	 * @param driverClassName nom du driverClassName
	 * @param url url de connexion  la base de donnes
	 * @param username nom d'utilisateur pour la connexion
	 * @param password password pour la connexion
	 * @param name nom du pool de connexion dans le fichier de config
	 */	
	public Database (String type, String driverClassName, String url, String username, String password, String name) {
		this.type = type.toUpperCase();
		this.driverClassName = driverClassName;
		this.url = url;
		this.username = username;
		this.password = password;
		this.name = name;
		if(this.type.equals("JDBC") && (this.driverClassName == null || this.url == null || this.username == null || this.password == null)) {
			if(logguer.isDebugEnabled()) {
			    logguer.debug("Database::Database() : Type connexion JDBC n\u00E9cessite les param\u00E8tres : " + "driverClassName, url, username et password ");
			}
		}				  
		else {
		    if (this.type.equals("JNDI") && (this.driverClassName != null || this.username != null	|| this.password != null)) {
		        if(logguer.isDebugEnabled()) {
				    logguer.debug("Database::Database() : Type connexion JNDI : Les param\u00E8tres driverClassName, url, username et password ne sont pas pris en compte");
		        }
		    }
		}
	}
	
	/**
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param string
	 */
	public void setType(String string) {
		type = string;
	}
	
	/**
	 * @return
	 */
	public String getDriverClassName() {
		return driverClassName;
	}

	/**
	 * @param string
	 */
	public void setDriverClassName(String string) {
		driverClassName = string;
	}

	/**
	 * @return
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * @param string
	 */
	public void setUrl(String string) {
		url = string;
	}

	/**
	 * @return
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param string
	 */
	public void setUsername(String string) {
		username = string;
	}

	/**
	 * @return
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param string
	 */
	public void setPassword(String string) {
		password = string;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}
}
