package org.esupportail.portal.utils.channels;

import java.util.HashMap;

import org.apache.log4j.Priority;

/**
 * IConfigActions<br>
 * <br>
 * Interface dcrivant les mthodes que doit implmenter une classe de configuration pour une channel
 * utilisant le framework<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="http://mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version $Revision: 1.1 $ 
 */

public interface IConfigActions extends Cloneable {
	
	/**
	 * Retourne la liste des actions lie  la configuration
	 * @return
	 */
	public HashMap getActions();
	
	/**
	 * Positionne la liste des actions lie  la configuration
	 * @param map
	 */
	public void setActions(HashMap map);
	
	/**
	 * Retourne l'encodage XML
	 * @return
	 */
	public String getXmlEncoding();
	
	/**
	 * Retourne le niveau de log
	 * @return
	 * @deprecated
	 */
	public Priority getLogLevel();
	
	/**
	 * Retourne le niveau de log sous forme de chane de caractres 
	 * @return
	 */
	public String getLog();
	
	/**
	 * Surcharge la mthode clone() de la classe Object
	 * Retourne un objet copie de l'objet courant
	 * @return
	 * @throws CloneNotSupportedException
	 */
	public Object clone() throws CloneNotSupportedException;
}
