package org.esupportail.portal.utils.channels;

import java.util.ArrayList;
import java.util.List;

/**
 * ActionParams<br>
 * <br>
 * Paramtre ventuellement associ  une action.
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version $Revision: 1.1 $
 */

public class ActionParam {
	
	private String name;
	private List values;
	
	/**
	 * Retourne le nom du paramtre
	 * @return
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Positionne le nom du paramtre
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * Retourne la valeur (ou la premire valeur dans le cas d'un paramtre multivalu)
	 * @return Returns
	 */
	public String getValue() {
		if (values != null)
			return (String) values.get(0);
		return null;
	}
	
	/**
	 * Retourne les valeurs
	 * @return
	 */
	public List getValues() {
		return values;
	}
	
	/**
	 * Positionne les valeurs
	 * @param values
	 */
	public void setValues(List values) {
		this.values = values;
	}
	
	/**
	 * Ajoute une valeur au paramtre
	 * @param value
	 */
	public void addParamValue(String value) {
		if (values == null)
			values = new ArrayList();
		values.add(value);
	}
}
