package org.esupportail.portal.utils.channels.plugins;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannelAjax;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * Message<br>
 * <br>
 * Ce plug-in ajoute une page qui permet d'afficher un message d'erreur, d'information ou de warning
 * avec ventuellement un bouton qui renvoie vers une nouvelle action<br>
 * Une liste de paramtres  transmettre  l'action suivante peut galement tre ajoute<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.2 $
 */

public class Message extends SubChannelAjax {
	
	public static final int ERROR = 0;
	public static final int INFO = 100;
	public static final int WARNING = 50;
	
	protected static Log logguer = LogFactory.getLog(Message.class);
	
	private static String plugName = "plug.esup.message";
	
	/**
	 * Constructeur
	 * @param main Channel principale
	 */
	public Message(MainChannel main) {
		super(main);
		if(logguer.isDebugEnabled()) {
		    logguer.debug("Message::Message()");
		}
	}
	
	/**
	 * Mthode statique qui permet d'enregistrer le plug-in error message dans la liste des actions d'un channel
	 * @param main Channel principale
	 */
	public static void register(MainChannel main) {
		Action action = new Action();
		action.setName(plugName);
		action.setClassname("org.esupportail.portal.utils.channels.plugins.Message");
		action.setXslfile("message.xsl");
		main.getConfigActions().getActions().put(action.getName(), action);
	}
	
	/**
	 * Mthode statique qui permet d'afficher un message associ  un icne<br>
	 * @param main Channel principale
	 * @param rd
	 * @param mb Le MessageBean  afficher
	 * @throws PortalException
	 */
	public static void message(MainChannel main, ChannelRuntimeData rd, MessageBean mb) throws PortalException {
	    Vector v = new Vector();
	    v.add(mb);
	    message(main, rd, v, "", new Hashtable());
	}
	
	/**
	 * Mthode statique qui permet d'afficher un message associ  un icne<br>
	 * @param main Channel principale
	 * @param rd
	 * @param mb Le MessageBean  afficher
	 * @param newAction L'action qui suivra le message
	 * @throws PortalException
	 */
	public static void message(MainChannel main, ChannelRuntimeData rd, MessageBean mb, String newAction) throws PortalException {
	    Vector v = new Vector();
	    v.add(mb);
	    message(main, rd, v, newAction, new Hashtable());
	}
	
	/**
	 * Mthode statique qui permet d'afficher un message associ  un icne<br>
	 * @param main Channel principale
	 * @param rd
	 * @param mb Le MessageBean  afficher
	 * @param newAction L'action qui suivra le message
	 * @param parameters Les paramtres  transmettre  l'action suivante
	 * @throws PortalException
	 */
	public static void message(MainChannel main, ChannelRuntimeData rd, MessageBean mb, String newAction, Hashtable parameters) throws PortalException {
	    Vector v = new Vector();
	    v.add(mb);
	    message(main, rd, v, newAction, parameters);
	}

	/**
	 * Mthode statique qui permet d'afficher une liste de messages associs  un icne<br>
	 * @param main Channel principale
	 * @param rd
	 * @param messages La liste des MessageBean  afficher
	 * @param newAction L'action qui suivra le message
	 * @param parameters Les paramtres  transmettre  l'action suivante
	 * @throws PortalException
	 */
	public static void message(MainChannel main, ChannelRuntimeData rd, Vector messages, String newAction, Hashtable parameters) throws PortalException {
	    StringBuffer message = new StringBuffer();
	    Iterator i = messages.iterator();
	    while(i.hasNext()) {
	        MessageBean tmp = (MessageBean)i.next();
	        message.append(tmp.toXMLString());
	    }
	    
	    rd.setParameter("_msg", message.toString());
	    rd.setParameter("_action", newAction);
	    rd.put("_parameters", parameters);
	    rd.setParameter("action", plugName);
	    main.setRuntimeData(rd);
	}
	
	/**
	 * Positionnement du XML pour le plug-in
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() throws FrameWorkException {
	    if(logguer.isDebugEnabled()) {
		    logguer.debug("Message::setXML()");
	    }
		StringBuffer xml = new StringBuffer();
		xml.append(getRuntimeData().getParameter("_msg"));
		xml.append("<action name=\"" + getRuntimeData().getParameter("_action") + "\" />");
		xml.append("<parameters>");
		Hashtable parameters = (Hashtable)getRuntimeData().get("_parameters");
		Enumeration keys = parameters.keys();
		while(keys.hasMoreElements()) {
			String key = (String)keys.nextElement();
			String value = (String)parameters.get(key);
			xml.append("<parameter name=\"" + key + "\" value=\"" + value + "\" />");
		}
		xml.append("</parameters>");
		setXML(xml.toString());
		return Boolean.TRUE;
	}
}