var AJAX_REPLACE_CONTENT = 'replaceContent';
var AJAX_REDIRECT = 'redirect';
// Indique si un traitement Ajax est en cours
var AJAX_RUNNING; 

function makeRequest(url,instanceName,paramsAjax,directUpdate,displayAjaxRunning) {
    /*if (directUpdate == 'undefined')
      directUpdate = false;*/
    if (AJAX_RUNNING) {
        alert('Traitement en cours...');
        return false;  
    }
    // Dbut traitement Ajax
    AJAX_RUNNING = true;  
    // Dbut de l'affichage du message de traitement en cours
    if (displayAjaxRunning)
        ap_showWaitMessage('waitDiv', 1);
    paramsAjax = paramsAjax + '&htmlId=' + instanceName;
    if (directUpdate) {
        // Fin traitement Ajax
        AJAX_RUNNING = false;
        paramsAjax = paramsAjax + '&directUpdate=1';
        var myAjax = new Ajax.Updater(instanceName, 
                                      url, 
                                      {method: 'post', parameters : paramsAjax, evalScripts: true});
    }
    else
        var myAjax = new Ajax.Request(url, {method: 'post', parameters : paramsAjax, onComplete: onResponse});
}

function onResponse(originalRequest) {
    // Fin traitement Ajax
    AJAX_RUNNING = false;
    // Fin de l'affichage du message de traitement en cours
    ap_showWaitMessage('waitDiv', 0);
    response = originalRequest.responseXML;
    // Tests pour Mozilla
    if (response == null) {
        badResponse(originalRequest.responseText);
		return false;
	}
    // Tests pour IE
    if (response.documentElement == null) {
        badResponse(originalRequest.responseText);
		return false;
	}
    // Element DOM correspondant à l'élément <response>
    response = response.documentElement.getElementsByTagName("response")[0];
	responseType = response.getAttribute("type");
	responseValue = response.firstChild.nodeValue;
	if (responseType == AJAX_REDIRECT)
	    redirect(responseValue);
	if (responseType == AJAX_REPLACE_CONTENT) {
        htmlID = response.getAttribute("htmlId");
	    replaceID(htmlID, responseValue);
	}
}

function badResponse(responseText) {
  window.location.reload();
}

function replaceID(htmlID, content) {
    var ScriptFragment = '(?:<script.*?>)((\r|\n|.)*?)(?:<\/script>)';
    var match    = new RegExp(ScriptFragment, 'img');
    var scripts  = content.match(match);
    $(htmlID).innerHTML = content;
    if (scripts) {
        match = new RegExp(ScriptFragment, 'im');
        for (var i = 0; i < scripts.length; i++) {
            if (scripts[i].match(match)[1]) {
            eval(scripts[i].match(match)[1]);
            }
        }
    }
}

function redirect(url) {
    window.location.href=url;
}

function submitRequest(url, form, htmlId, params,directUpdate,displayAjaxRunning) {
      makeRequest(url, htmlId, Form.serialize(form) + '&' + params,directUpdate,displayAjaxRunning);
      return false;
}

// Affichage du message de chargement
// Mthodes ap_getObj et ap_showWaitMessage
var DHTML = (document.getElementById || document.all || document.layers);

function ap_getObj(name) { 
    if (document.getElementById && document.getElementById(name)) { 
        return document.getElementById(name).style; 
    } 
    else if (document.all && document.all[name]) { 
        return document.all[name].style;
    } 
    else if (document.layers && document.layers[name]) { 
        return document.layers[name]; 
    } 
} 

function ap_showWaitMessage(div,flag)  { 
    if (!DHTML) 
        return; 
    var x = ap_getObj(div);
    if (!x)
        return; 
    x.visibility = (flag) ? 'visible':'hidden'
    if (!document.getElementById) 
        if(document.layers) 
            x.left=280/2; 
    return true; 
}

