<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <!-- Importation d'autres feuilles de style -->
  <xsl:import href="/org/esupportail/portal/utils/channels/templates/ajax.xsl"/>
  <!--<xsl:import href="file:/C:/esupdev/eclipse/workspace/esup-utils-mag/webpages/stylesheets/org/esupportail/portal/utils/channels/templates/ajax.xsl"/>-->
  <!-- Type de rendu -->
  <xsl:output method="html" indent="no"/>
  <!-- Paramtres -->
  <xsl:param name="baseActionURL"/>
  <xsl:param name="prefForm"/>
  <xsl:param name="mediaPath"/>
  <xsl:template match="/xml">
    <xsl:variable name="typForm">
      <xsl:choose>
        <xsl:when test="$ajaxCalled='true'">div</xsl:when>
        <xsl:otherwise>form</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <!-- Affichage des messages -->
    <xsl:element name="{$typForm}">
      <xsl:attribute name="name"><xsl:value-of select="$prefForm"/>Confirm</xsl:attribute>
      <xsl:attribute name="id"><xsl:value-of select="$prefForm"/>Confirm</xsl:attribute>
      <xsl:attribute name="action"><xsl:value-of select="$baseActionURL"/></xsl:attribute>
      <xsl:attribute name="method">post</xsl:attribute>
      <input name="_confirm" id="_confirm" value="Oui" type="hidden"/>
      <input type="hidden" name="action" value="{./action/@name}"/>
      <table border="0" cellspacing="5">
        <tr>
          <td valign="absmiddle">
            <img src="{$mediaPath}warningmessage.gif" border="0"/>
          </td>
          <td class="uportal-channel-error">
            <xsl:value-of select="./msg/@value"/>
          </td>
        </tr>
      </table>
      <xsl:apply-templates select="./parameters/parameter"/>
      <input class="uportal-button" type="button" value="Oui" name="_confirmOui">
        <xsl:attribute name="onclick">
          <xsl:call-template name="onEventSubmitAjax">
            <xsl:with-param name="formId">Confirm</xsl:with-param>
            <xsl:with-param name="htmlId">
              <xsl:value-of select="$htmlId"/>
            </xsl:with-param>
            <xsl:with-param name="ajaxId">
              <xsl:value-of select="$ajaxId"/>
            </xsl:with-param>
            <xsl:with-param name="ajaxOnly">true</xsl:with-param>
            <xsl:with-param name="prependPrefForm">false</xsl:with-param>
            <xsl:with-param name="displayAjaxRunning"><xsl:value-of select="/xml/displayAjaxRunning/@value"/></xsl:with-param>
          </xsl:call-template>
        </xsl:attribute>
      </input>
      <input class="uportal-button" type="button" value="Non" name="_confirmNon">
        <xsl:attribute name="onclick">
          <!--
        <xsl:text>document.getElementById("</xsl:text>
        <xsl:value-of select="$prefForm"/>
        <xsl:text>Confirm")._confirm.value='Non';</xsl:text>
        -->
          <xsl:text>this.parentNode.firstChild.value='Non';</xsl:text>
          <xsl:call-template name="onEventSubmitAjax">
            <xsl:with-param name="formId">Confirm</xsl:with-param>
            <xsl:with-param name="htmlId">
              <xsl:value-of select="$htmlId"/>
            </xsl:with-param>
            <xsl:with-param name="ajaxId">
              <xsl:value-of select="$ajaxId"/>
            </xsl:with-param>
            <xsl:with-param name="ajaxOnly">true</xsl:with-param>
            <xsl:with-param name="prependPrefForm">false</xsl:with-param>
          </xsl:call-template>
        </xsl:attribute>
      </input>
    </xsl:element>
  </xsl:template>
  <!-- Si paramtres  transmettre insertion en champs cachs -->
  <xsl:template match="parameter">
    <input type="hidden" name="{./@name}" value="{./@value}"/>
  </xsl:template>
</xsl:stylesheet>
