<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- Importation d'autres feuilles de style -->
	<xsl:import href="/org/esupportail/portal/utils/channels/templates/ajax.xsl"/>
	<!--
	<xsl:import href="file:/C:/esupdev/eclipse/workspace/esup-utils-mag/webpages/stylesheets/org/esupportail/portal/utils/channels/templates/ajax.xsl"/>
	-->
	<!-- Type de rendu -->
	<xsl:output method="html" indent="no" />
	<!-- Paramtres -->
	<xsl:param name="baseActionURL"></xsl:param>
  	<xsl:param name="prefForm"></xsl:param>
  	<xsl:param name="mediaPath"></xsl:param>
	
<xsl:template match="/xml">
	<!-- Affichage des messages -->	
	<table border="0" cellspacing="5">
    	<xsl:apply-templates select="message" />
    </table>
    <!-- Si action alors cration du formulaire -->
    <xsl:if test="./action/@name != ''">
    	<form name="{$prefForm}Message" id="{$prefForm}Message"  action="{$baseActionURL}" method="post">
		<input type="hidden" name="action" value="{./action/@name}" />
		
		<xsl:apply-templates select="./parameters/parameter" />
		
			<input class="uportal-button" type="button" value="OK" name="save">
				<xsl:attribute name="onclick">
					<xsl:call-template name="onEventSubmitAjax">
						<xsl:with-param name="formId">Message</xsl:with-param>
						<xsl:with-param name="htmlId"><xsl:value-of select="$htmlId"/></xsl:with-param>
						<xsl:with-param name="ajaxId"><xsl:value-of select="$ajaxId"/></xsl:with-param>
						<xsl:with-param name="ajaxOnly">true</xsl:with-param>
						<xsl:with-param name="prependPrefForm">false</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</input>
		</form>
	</xsl:if>
</xsl:template>

<!-- Affichage d'un message -->
<xsl:template match="message">
	<tr>
		<xsl:choose>
			<xsl:when test="./@type='ERROR'">
				<td valign="absmiddle"><img src="{$mediaPath}errormessage.gif" border="0"/></td>
			</xsl:when>
			<xsl:when test="./@type='WARNING'">
				<td valign="absmiddle"><img src="{$mediaPath}warningmessage.gif" border="0"/></td>
			</xsl:when>
			<xsl:when test="./@type='INFO'">
				<td valign="absmiddle"><img src="{$mediaPath}infomessage.gif" border="0"/></td>
			</xsl:when>
		</xsl:choose>
    	
    	<td class="uportal-channel-error"><xsl:value-of select="./@message"/></td>
    </tr>
</xsl:template>

<!-- Si paramtres  transmettre insertion en champs cachs -->	
<xsl:template match="parameter">
	<input type="hidden" name="{./@name}" value="{./@value}" />
</xsl:template>

</xsl:stylesheet>