package org.esupportail.portal.utils.channels;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/** 
 * FrameWorkException<br>
 * <br>
 * Classe de gestion des erreurs du Framework<br>
 * <br>
 * (c)Copyright <a href="http://www.univ-nancy2.fr">CRI Nancy 2 2004</a><br>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version $Revision: 1.2 $
 */

public class FrameWorkException extends Exception {
	
	private static final long serialVersionUID = 3762257452204569906L;

	protected static Log logguer = LogFactory.getLog(FrameWorkException.class);
    
    private String displayMessage;
	private String message;
	private String msgDefault = "Une erreur est survenue dans l'ex\u00E9cution du canal. Veuillez r\u00E9essayer ult\u00E9rieurement.";
	
	/**
	* Constructeur 
	* @param conf fichier de configuration
	* @param msg message insr dans le mail
	*/
	public FrameWorkException (IConfigMail conf, String msg) {
		setMessage(msg);
		if(conf.getDisplayError() != null) {
			setDisplayMessage(conf.getDisplayError());
		}
		else {
			setDisplayMessage(msgDefault);
		}
		Mail m = new Mail(conf);
		m.setMessage("<b>"+m.getMessage()+"</b><p><blockquote>"+msg+"</blockquote></p>");
		try {
			m.send(null);
		}
		catch(Exception e) {
			logguer.error("FrameWorkException::FrameWorkException() : Exception :\n" + e);
		}
	}

	/**
	* Constructeur 
	* @param conf fichier de configuration
	* @param msg message insr dans le mail
	* @param stack tat de la pile au moment de l'erreur
	*/
	public FrameWorkException(IConfigMail conf, String msg, String stack) {
		setMessage(msg);
		if (conf.getDisplayError() != null) {
			setDisplayMessage(conf.getDisplayError());
		}
		else {
			setDisplayMessage(msgDefault);
		}
		Mail m = new Mail(conf);
		m.setMessage("<b>"+m.getMessage()+"</b><p><blockquote>"+msg+"</blockquote></p>"+
					 "<p><b>StackTrace : </b><br>"+stack+"</p>");
		try {
			m.send(null);
		}
		catch(Exception e) {
			logguer.error("FrameWorkException::FrameWorkException() : Exception :\n" + e);
		}
	}

	/**
	* Constructeur
	* @param displayMessage
	*/
	public FrameWorkException (String displayMessage) {
		setDisplayMessage(displayMessage);
	}

	/**
	* Constructeur
	*/
	public FrameWorkException () {
		setDisplayMessage(msgDefault);
	}		
		
	/**
	 * Retourne le message d'erreur
	 * @return
	 */
	public String getDisplayMessage() {
		return displayMessage;
	}

	/**
	 * Positionne le message d'erreur
	 * @param string
	 */
	public void setDisplayMessage(String string) {
		displayMessage = string;
	}

	/**
	 * Retourne le message
	 * @return
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * Positionne le message
	 * @param string
	 */
	public void setMessage(String string) {
		message = string;
	}

	/**
	 * Retourne le message par dfaut
	 * @return
	 */
	public String getMsgDefault() {
		return msgDefault;
	}

	/**
	 * Positionne le message par dfaut
	 * @param string
	 */
	public void setMsgDefault(String string) {
		msgDefault = string;
	}
}
