<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Template utilis pour gnrer des liens compatibles avec des appels AJAX dans le mag
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <!-- Type de rendu -->
    <xsl:output method="html" indent="yes"/>
    <!-- Paramtres -->
    <xsl:param name="baseDownloadURL"/>
    <xsl:param name="mediaPathMAG"/>
    <xsl:param name="ajaxEnabled">false</xsl:param>
    <xsl:param name="ajaxCalled">false</xsl:param>
    <xsl:param name="htmlId"/>
    <xsl:param name="ajaxId"/>
    <!-- 
        Inclusion des fichiers javascript ncessaire aux appels Ajax
    -->
    <xsl:template name="includeJsAjax">
        <script language="javascript">
            var global = (function(){return this;})();
        </script> 
        <xsl:if test="$ajaxEnabled='true'">
            <xsl:element name="script">
                <xsl:attribute name="type">text/javascript</xsl:attribute>
                <xsl:attribute name="src"><xsl:value-of select="$mediaPathMAG"
                />ajax/ajaxMag.js</xsl:attribute>
            </xsl:element>
            <xsl:element name="script">
                <xsl:attribute name="type">text/javascript</xsl:attribute>
                <xsl:attribute name="src"><xsl:value-of select="$mediaPathMAG"
                />ajax/prototype.js</xsl:attribute>
            </xsl:element>
        </xsl:if>
        <!-- Message de traitement en cours -->
        <div id='waitDiv' style='position:absolute;left:40%;top:40%;visibility:hidden;text-align: center;'>
            <table border='1' bgcolor="#FFFFCC" cellpadding="20" cellspacing="0">
                <tr>
                    <td align='center' class='uportal-channel-strong'>
                        Traitement en cours...
                        <p><img src='{$mediaPathMAG}/ajax/await.gif' alt=''/></p>
                        SVP Patientez...
                    </td>
                </tr>
            </table>
        </div>
    </xsl:template>
    <!-- 
    Gnration d'un attribut HREF pour appel Ajax ou non 
    -->
    <xsl:template name="hrefAjax">
        <!-- nom de l'lment html de la page en cours qui va tre remplac par le rsultat de l'appel AJAX -->
        <xsl:param name="htmlId"/>
        <!-- nom de l'lment html <ajax_#ajaxID#> qui doit tre retourn par l'appel AJAX. Cet lment va se substituer au contenu de htmlId -->
        <xsl:param name="ajaxId"/>
        <!-- liste des paramtres  transmettre lors de l'appel Ajax. Pas de ? au dbut -->
        <xsl:param name="params"/>
        <!-- prcise si l'on souhaite gnrer un lien Ajax -->
        <xsl:param name="ajaxLink">true</xsl:param>
        <!-- prcise si un lien ajax ne peut tre gnr que si on est en train de rpondre  une requte Ajax -->
        <xsl:param name="ajaxOnly">false</xsl:param>
        <!-- Affichage du message de traitement en cours. A false par dfaut -->
        <xsl:param name="displayAjaxRunning">false</xsl:param>
        <xsl:choose>
            <xsl:when test="$ajaxEnabled='true' and $ajaxLink='true' and (($ajaxOnly='true' and
                $ajaxCalled='true') or ($ajaxOnly='false'))">
                <xsl:attribute name="href">#</xsl:attribute>
                <xsl:attribute name="onclick">
                    <xsl:call-template name="onEventAjax">
                        <xsl:with-param name="htmlId"><xsl:value-of select="$htmlId"/></xsl:with-param>
                        <xsl:with-param name="ajaxId"><xsl:value-of select="$ajaxId"/></xsl:with-param>
                        <xsl:with-param name="params"><xsl:value-of select="$params"/></xsl:with-param>
                        <xsl:with-param name="displayAjaxRunning"><xsl:value-of select="$displayAjaxRunning"/></xsl:with-param>
                    </xsl:call-template> 
                </xsl:attribute>    
                <!--<xsl:attribute name="onclick">
                    <xsl:text>makeRequest('</xsl:text>
                    <xsl:value-of select="$baseDownloadURL"/>
                    <xsl:text>','</xsl:text>
                    <xsl:value-of select="$prefForm"/>
                    <xsl:value-of select="$htmlId"/>
                    <xsl:text>','ajaxCall=1&amp;ajaxId=</xsl:text>
                    <xsl:value-of select="$ajaxId"/>
                    <xsl:text>&amp;</xsl:text>
                    <xsl:value-of select="$params"/>
                    <xsl:text>')</xsl:text>
                </xsl:attribute>-->
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="href">
                    <xsl:value-of select="$baseActionURL"/>
                    <xsl:text>?</xsl:text>
                    <xsl:value-of select="$params"/>
                </xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Gnration d'un vnement : onClick, onChange -->    
    <xsl:template name="onEventAjax">
        <!-- Nom de l'lment html de la page en cours qui va tre remplac par le rsultat de l'appel AJAX -->
        <xsl:param name="htmlId"/>
        <!-- Nom de l'lment html <ajax_#ajaxID#> qui doit tre retourn par l'appel AJAX. Cet lment va se substituer au contenu de htmlId -->
        <xsl:param name="ajaxId"/>
        <!-- Liste des paramtres  transmettre lors de l'appel Ajax. Pas de ? au dbut -->
        <xsl:param name="params"/>
        <!-- Prcise si on veut directement mettre  jour l'lment htmlID avec le rsultat de l'appel Ajax -->
        <xsl:param name="directUpdate">false</xsl:param>
        <!-- Affichage du message de traitement en cours. A false par dfaut -->
        <xsl:param name="displayAjaxRunning">false</xsl:param>
        <xsl:text>makeRequest('</xsl:text>
        <xsl:value-of select="$baseDownloadURL"/>
        <xsl:text>','</xsl:text>
        <xsl:value-of select="$prefForm"/>
        <xsl:value-of select="$htmlId"/>
        <xsl:text>','ajaxCall=1&amp;ajaxId=</xsl:text>
        <xsl:value-of select="$ajaxId"/>
        <xsl:text>&amp;</xsl:text>
        <xsl:value-of select="$params"/>
        <xsl:text>',</xsl:text>
        <xsl:value-of select="$directUpdate"/>
        <xsl:text>,</xsl:text>
        <xsl:value-of select="$displayAjaxRunning"/>
        <xsl:text>)</xsl:text>
    </xsl:template>
    
    
    
    <!-- 
        Gnration d'un attribut onclick pour appel Ajax ou non dans un bouton de formulaire 
    -->
    <xsl:template name="onEventSubmitAjax">
        <!-- nom du formulaire -->
        <xsl:param name="formId"/>
        <!-- nom de l'lment html de la page en cours qui va tre remplac par le rsultat de l'appel AJAX -->
        <xsl:param name="htmlId"/>
        <!-- nom de l'lment <ajax_#ajaxID#> qui contient le html  retourner par l'appel AJAX. Cet lment va se substituer au contenu de htmlId -->
        <xsl:param name="ajaxId"/>
        <!-- prcise si l'on souhaite gnrer un lien Ajax -->
        <xsl:param name="ajaxLink">true</xsl:param>
        <!-- prcise si un lien ajax ne peut tre gnr que si on est en train de rpondre  une requte Ajax -->
        <xsl:param name="ajaxOnly">false</xsl:param>
        <!-- Indique si l'on veut automatiquement ajouter le prefForm devant le nom des objets htmlId et ajaxId passs en paramtre -->
        <xsl:param name="prependPrefForm">true</xsl:param>
        <!-- prcise si on veut directement mettre  jour l'lment htmlID avec le rsultat de l'appel Ajax -->
        <xsl:param name="directUpdate">false</xsl:param>
        <!-- Affichage du message de traitement en cours. A false par dfaut -->
        <xsl:param name="displayAjaxRunning">false</xsl:param>
        <xsl:choose>
            <xsl:when test="($ajaxEnabled='true' or ($ajaxOnly='true'and $ajaxCalled='true'))
                and $ajaxLink='true' and (($ajaxOnly='true' and $ajaxCalled='true') 
                or ($ajaxOnly='false'))">
                <xsl:text>return submitRequest('</xsl:text>
                <xsl:value-of select="$baseDownloadURL"/>
                <xsl:text>','</xsl:text>
                <xsl:value-of select="$prefForm"/>
                <xsl:value-of select="$formId"/>
                <xsl:text>','</xsl:text>
                <xsl:if test="$prependPrefForm='true'">
                    <xsl:value-of select="$prefForm"/>
                </xsl:if>
                <xsl:value-of select="$htmlId"/>
                <xsl:text>','ajaxCall=1&amp;ajaxId=</xsl:text>
                <xsl:value-of select="$ajaxId"/>
                <xsl:text>',</xsl:text>
                <xsl:value-of select="$directUpdate"/>
                <xsl:text>,</xsl:text>
                <xsl:value-of select="$displayAjaxRunning"/>
                <xsl:text>);</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>return submit();</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
 </xsl:stylesheet>
